# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 6
# Experiment: PMxPM, Run: 3
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR6_strategy.txt
# LLM Suggested Fallback: C

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR6(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Final round: defect to maximize payoff
    if current_round == 10:
        return "D"
    
    # First round: cooperate to signal willingness
    if current_round == 1:
        return "C"
    
    # Check if opponent always cooperates or always defects
    always_cooperate = "return 'C'" in opponent_program_code or "always cooperate" in opponent_program_code.lower()
    always_defect = "return 'D'" in opponent_program_code or "always defect" in opponent_program_code.lower()
    
    # Exploit always-cooperate or always-defect opponents
    if always_cooperate or always_defect:
        return "D"
    
    # Default to tit-for-tat: mirror opponent's last move
    return opp_history[-1]